<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-as-a-service
* @subpackage libraries
*/

/** Grab the parent class */
require_once 'DPII_Email.php';

/**
* @package direct-as-a-service
* @subpackage libraries
*/
class Mime_generator extends DPII_Email{
	var $protocol = 'smtp';
	protected $raw_mime = '';
		
	
	public function raw_mime(){
		$this->raw_mime; //reset the raw_mime so that we don't accidentally concat more than once
		$this->send(); //the send method will put together all the pieces, but we've overrided critical methods so that it will append to string instead of sending the mail
		return $this->raw_mime;
	}
	
	public function size_in_bytes(){
		return string_length_in_bytes($this->raw_mime); 
	}
	
	/** Overrides parent to record the data as a string instead of sending to the smtp server */
	protected function _send_data($data){
		$this->raw_mime .= $data . $this->newline;
		return TRUE;
    }
	
	protected function _send_with_mail(){
		trigger_error('Mail capabilities are not enabled for the Mime_generator library', E_USER_WARNING);
	}
	
	//make sure that we can't accidentally send email via sendmail
	protected function _send_with_sendmail(){
		trigger_error('Sendmail capabilities are not enabled for the Mime_generator library', E_USER_WARNING);
    }
	
	/** 
	* Overrides parent to remove smtp connection/authentication step.
	* Modifications will remain commented out for easy comparison to the parent function if upgrading CI in future
	*/
	protected function _send_with_smtp()
    {
		
/*      if ($this->smtp_host == '')
        {
            $this->_set_error_message('lang:email_no_hostname');
            return FALSE;
        }
 
        $this->_smtp_connect();
        $this->_smtp_authenticate(); */
 
       # $this->_send_command('from', $this->clean_email($this->_headers['From']));
 
        foreach ($this->_recipients as $val)
        {
            $this->_send_command('to', $val);
        }
 
        if (count($this->_cc_array) > 0)
        {
            foreach ($this->_cc_array as $val)
            {
                if ($val != "")
                {
                    $this->_send_command('to', $val);
                }
            }
        }
 
        if (count($this->_bcc_array) > 0)
        {
            foreach ($this->_bcc_array as $val)
            {
                if ($val != "")
                {
                    $this->_send_command('to', $val);
                }
            }
        }
 
/*      $this->_send_command('data'); */
 
        // perform dot transformation on any lines that begin with a dot
        $this->_send_data($this->_header_str . preg_replace('/^\./m', '..$1', $this->_finalbody));
 /*
        $this->_send_data('.');
 	
		
        $reply = $this->_get_smtp_data();
 
        $this->_set_error_message($reply);
 
        if (strncmp($reply, '250', 3) != 0)
        {
            $this->_set_error_message('lang:email_smtp_error', $reply);
            return FALSE;
        } 
 
        $this->_send_command('quit'); */
        return TRUE;
    }
	
	/** 
	* Overrides parent to remove checking for SMTP 
	* Modifications will remain commented out for easy comparison to the parent function if upgrading CI in future
	*/
    protected function _send_command($cmd, $data = '')
    {
        switch ($cmd)
        {
            case 'hello' :
 
                    if ($this->_smtp_auth OR $this->_get_encoding() == '8bit')
                        $this->_send_data('EHLO '.$this->_get_hostname());
                    else
                        $this->_send_data('HELO '.$this->_get_hostname());
 
                        $resp = 250;
            break;
            case 'starttls'    :
 
                        $this->_send_data('STARTTLS');
 
                        $resp = 220;
            break;
            case 'from' :
 
                        $this->_send_data('MAIL FROM:<'.$data.'>');
 
                        $resp = 250;
            break;
            case 'to'    :
 
                        $this->_send_data('RCPT TO:<'.$data.'>');
 
                        $resp = 250;
            break;
            case 'data'    :
 
                        $this->_send_data('DATA');
 
                        $resp = 354;
            break;
            case 'quit'    :
 
                        $this->_send_data('QUIT');
 
                        $resp = 221;
            break;
        }
 
        /*$reply = $this->_get_smtp_data();
 
        $this->_debug_msg[] = "<pre>".$cmd.": ".$reply."</pre>";
 
        if (substr($reply, 0, 3) != $resp)
        {
            $this->_set_error_message('lang:email_smtp_error', $reply);
            return FALSE;
        }
 
        if ($cmd == 'quit')
        {
            fclose($this->_smtp_connect);
        } */
 
        return TRUE;
    }
 
	
	


}
// END DPII_Email class

/* End of file Email.php */
/* Location: ./application/libraries/DPII_Email.php */
